<?php
/*--------------------------------------------------------------------------------------------------
    GetSellingUnitReservedQuantityEvent.php 2020-3-9
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2016 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\SellingUnit\Database\Unit\Events;

use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\GetSellingUnitReservedQuantityEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\ReservedQuantity;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;
use ProductDataInterface;

/**
 * Class GetProductReservedQuantityEvent
 */
class GetSellingUnitReservedQuantityEvent implements GetSellingUnitReservedQuantityEventInterface
{
    /**
     * @var SellingUnitId
     */
    protected $id;
    /**
     * @var ReservedQuantity
     */
    protected $quantity;
    /**
     * @var bool
     */
    protected $propagationStopped = false;
    /**
     * @var ProductDataInterface
     */
    protected $productData;


    /**
     * GetSellingUnitReservedQuantityEvent constructor.
     * @param SellingUnitId $id
     * @param ProductDataInterface $productData
     */
    public function __construct(SellingUnitId $id, ProductDataInterface $productData)
    {

        $this->id = $id;
        $this->productData = $productData;
        $this->quantity = new ReservedQuantity(0,'');
    }

    /**
     * @inheritDoc
     */
    public function id(): SellingUnitId
    {
        return $this->id;
    }

    /**
     * @inheritDoc
     */
    public function isPropagationStopped(): bool
    {
        return $this->propagationStopped;
    }

    /**
     * @inheritDoc
     */
    public function quantity(): ?ReservedQuantity
    {
        return $this->quantity;
    }

    /**
     * @inheritDoc
     */
    public function setQuantity(ReservedQuantity $reservedQuantity): void
    {
        $this->quantity = $reservedQuantity;
    }

    public function stop(): void
    {
        $this->propagationStopped = true;
    }
}